<?php
namespace VM\AdminBundle\Command;

use Doctrine\Bundle\DoctrineBundle\Registry;
use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Entity\CompanyOfferReport;
use VM\ApiBundle\Entity\AccountChange;

class ChangeRoundUserToGroupCommand extends ContainerAwareCommand
{
    private $Container;

    protected function configure()
    {
        $this
            ->setName('change:round:user:group')
            ->setDescription('Assign rounds to groups, not users')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $EntityManager = $this->getDoctrine();

        try
        {
            $this->runNativeSQLQuery("
                ALTER TABLE rounds DROP FOREIGN KEY FK_3A7FD554A76ED395;
            ");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("
                DROP INDEX IDX_3A7FD554A76ED395 ON rounds;
            ");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("ALTER TABLE rounds CHANGE user_id user_group_id INT NOT NULL;");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("
                SET foreign_key_checks = 0;
                ALTER TABLE rounds ADD CONSTRAINT FK_3A7FD5541ED93D47 FOREIGN KEY (user_group_id) REFERENCES users_groups (id);
                SET foreign_key_checks = 1;
            ");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("CREATE INDEX IDX_3A7FD5541ED93D47 ON rounds (user_group_id);");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("
                UPDATE rounds AS r
                LEFT JOIN users_groups AS ug
                ON r.user_group_id = ug.user_id
                SET r.user_group_id = ug.id
                WHERE r.user_group_id = ug.user_id;
            ");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("
                ALTER TABLE users_groups ADD was_reset TINYINT(1) NOT NULL;
            ");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        $output->writeln("Koniec.");
    }


    /**
     * @return EntityManager
     */
    protected function getDoctrine()
    {
        return $this->getContainer()->get('doctrine.orm.default_entity_manager');
    }

    protected function runNativeSQLQuery($query)
    {
        $stmt = $this->getDoctrine()
            ->getConnection()
            ->prepare($query);
        $stmt->execute();
    }
}